﻿#include  "StdAfx.h"

#include  "szArchiveFileUpdaterImpl.hpp"
#include  <szArchiveOpenClientCallback.hpp>
#include  <szArchiveFileUpdateClientCallback.hpp>
#include  <szGetPasswordClientCallback.hpp>

SZ_NS_BEG(szpp)

ArchiveFileUpdaterImpl::ArchiveFileUpdaterImpl(
  ArchiveOpenClientCallback *openCallback,
  ArchiveFileUpdateClientCallback *updCallback,
  GetPasswordClientCallback *pwdCallback)
: 
#ifndef _NO_CRYPTO
  openPwdDefined(false), openPwdAsked(false), openPwd(), updPwdDefined(false), updPwd(),
#endif
  openCallback(openCallback), updCallback(updCallback), pwdCallback(pwdCallback)
{
}

ArchiveFileUpdaterImpl::~ArchiveFileUpdaterImpl()
{
}

//
// IOpenCallbackUI
//

#ifndef _NO_CRYPTO
HRESULT ArchiveFileUpdaterImpl::Open_CryptoGetTextPassword(BSTR *password)
{
  openPwdAsked = true;

  // コールバックが設定すらされていない場合は S_FALSE を返すようにしている
  HRESULT hr = S_FALSE;
  if (0 != pwdCallback)
  {
    szstring clientPassword;
    if (SUCCEEDED(hr = pwdCallback->GetPassword(&clientPassword)))
    {
      openPwd.assign(clientPassword);
      openPwdDefined = true;
      hr = StringToBstr(clientPassword.c_str(), password);
    }
  }
  return hr;
}

HRESULT ArchiveFileUpdaterImpl::Open_GetPasswordIfAny(UString &password)
{
  if (openPwdDefined)
    password = openPwd.c_str();
  return S_OK;
}

bool ArchiveFileUpdaterImpl::Open_WasPasswordAsked()
{
  return openPwdAsked;
}

void ArchiveFileUpdaterImpl::Open_ClearPasswordWasAskedFlag()
{
  openPwdAsked = false;
}
#endif

HRESULT ArchiveFileUpdaterImpl::Open_CheckBreak()
{
  return S_OK;
}

HRESULT ArchiveFileUpdaterImpl::Open_SetTotal(const UInt64 *files, const UInt64 *bytes)
{
  if (0 != openCallback)
  {
    const u64 nFiles = (files ? *files : 0);
    const u64 nBytes = (bytes ? *bytes : 0);
    return openCallback->SetTotal(nFiles, nBytes);
  }

  return S_OK;
}

HRESULT ArchiveFileUpdaterImpl::Open_SetCompleted(const UInt64 *files, const UInt64 *bytes)
{
  if (0 != openCallback)
  {
    const u64 nFiles = (files ? *files : 0);
    const u64 nBytes = (bytes ? *bytes : 0);
    return openCallback->SetCompleted(nFiles, nBytes);
  }

  return S_OK;
}

//
// IUpdateCallbackUI
//

HRESULT ArchiveFileUpdaterImpl::SetTotal(UInt64 size)
{
  return (0 != updCallback) ? updCallback->SetTotal(static_cast<u64>(size)) : S_OK;
}

HRESULT ArchiveFileUpdaterImpl::SetCompleted(const UInt64 *completeValue)
{
  if (0 != updCallback)
  {
    const u64 compSize = (completeValue != 0) ? *completeValue : 0;
    return updCallback->SetCompleted(compSize);
  }
  return S_OK;
}

HRESULT ArchiveFileUpdaterImpl::SetRatioInfo(const UInt64 *inSize, const UInt64 *outSize)
{
  if (0 != updCallback)
  {
    const u64 iSize = (inSize != 0) ? *inSize : 0;
    const u64 oSize = (outSize != 0) ? *outSize : 0;
    return updCallback->SetRatioInfo(iSize, oSize);
  }
  return S_OK;
}

HRESULT ArchiveFileUpdaterImpl::CheckBreak()
{
  return (0 != updCallback) ? updCallback->CheckBreak() : S_OK;
}

HRESULT ArchiveFileUpdaterImpl::Finilize()
{
  return (0 != updCallback) ? updCallback->Finalize() : S_OK;
}

HRESULT ArchiveFileUpdaterImpl::SetNumFiles(UInt64 numFiles)
{
  return (0 != updCallback) ? updCallback->SetNumFiles(static_cast<u64>(numFiles)) : S_OK;
}

HRESULT ArchiveFileUpdaterImpl::GetStream(const wchar_t *name, bool isAnti)
{
  if (0 != updCallback)
  {
    const szstring nameStr(name);
    return updCallback->GetStream(nameStr, isAnti);
  }
  return S_OK;
}

HRESULT ArchiveFileUpdaterImpl::OpenFileError(const wchar_t *name, DWORD systemError)
{
  if (0 != updCallback)
  {
    const szstring nameStr(name);
    return updCallback->OpenFileError(nameStr, static_cast<u32>(systemError));
  }
  return S_OK;
}

HRESULT ArchiveFileUpdaterImpl::SetOperationResult(Int32 operationResult)
{
  return (0 != updCallback) ? updCallback->SetOperationResult(static_cast<u32>(operationResult)) : S_OK;
}

HRESULT ArchiveFileUpdaterImpl::CryptoGetTextPassword2(Int32 *passwordIsDefined, BSTR *password)
{
  // 既にパスワードがあればそれを返すが、なければないで別にいいらしい
  *passwordIsDefined = updPwdDefined;
  if (updPwdDefined)
    return StringToBstr(updPwd.c_str(), password);
  return S_OK;

  //HRESULT hr = S_OK;
  //if (0 != updCallback)
  //{
  //  u32 isDefined;
  //  szstring passwordStr;
  //  if (SUCCEEDED(hr = updCallback->CryptoGetTextPassword2(&isDefined, &passwordStr)))
  //    if (SUCCEEDED(hr = StringToBstr(passwordStr.c_str(), password)))
  //      *passwordIsDefined = static_cast<Int32>(isDefined);
  //}
  //else
  //{
  //  *passwordIsDefined = 0;
  //}
  //return hr;
}

HRESULT ArchiveFileUpdaterImpl::CryptoGetTextPassword(BSTR *password)
{
  HRESULT hr = S_FALSE;
  if (0 != updCallback)
  {
    szstring passwordStr;
    if (SUCCEEDED(hr = updCallback->CryptoGetTextPassword(&passwordStr)))
      hr = StringToBstr(passwordStr.c_str(), password);
  }
  return hr;
}

//
// IUpdateCallbackUI2
//

HRESULT ArchiveFileUpdaterImpl::OpenResult(const wchar_t *name, HRESULT result)
{
  if (0 != updCallback)
  {
    const szstring nameStr(name);
    return updCallback->OpenResult(nameStr, result);
  }
  return S_OK;
}

HRESULT ArchiveFileUpdaterImpl::StartScanning()
{
  return (0 != updCallback) ? updCallback->StartScanning() : S_OK;
}

HRESULT ArchiveFileUpdaterImpl::ScanProgress(UInt64 numFolders, UInt64 numFiles, const wchar_t *path)
{
  if (0 != updCallback)
  {
    const szstring pathStr(path);
    return updCallback->ScanProgress(static_cast<u64>(numFolders), static_cast<u64>(numFiles), pathStr);
  }
  return S_OK;
}

HRESULT ArchiveFileUpdaterImpl::CanNotFindError(const wchar_t *name, DWORD systemError)
{
  if (0 != updCallback)
  {
    const szstring nameStr(name);
    return updCallback->CanNotFindError(nameStr, static_cast<u32>(systemError));
  }
  return S_OK;
}

HRESULT ArchiveFileUpdaterImpl::FinishScanning()
{
  return (0 != updCallback) ? updCallback->FinishScanning() : S_OK;
}

HRESULT ArchiveFileUpdaterImpl::StartArchive(const wchar_t *name, bool updating)
{
  if (0 != updCallback)
  {
    const szstring nameStr(name);
    return updCallback->StartArchive(nameStr, updating);
  }
  return S_OK;
}

HRESULT ArchiveFileUpdaterImpl::FinishArchive()
{
  return (0 != updCallback) ? updCallback->FinishArchive() : S_OK;
}

#ifndef _NO_CRYPTO
void ArchiveFileUpdaterImpl::SetInitialPassword(const szstring &password)
{
  updPwdDefined = true;
  updPwd.assign(password);
  openPwdDefined = true;
  openPwd.assign(password);
}
#endif

SZ_NS_END(szpp)
